function S_barchart(D)

% Matrix D, consisting of prototype vectors which represent neurons within
% the map trained by SOM with 'ep' neighborhood function,can be permutated
% in both row-wise (within neuron) and column-wise (within array) manner to 
% generate randomized distribution.

% Here, we propose to use the permutated Drc to decide on the significant
% eigenneurons. That is, the maximum relative eigenexpression (variance) 
% calculated from Drc as cutoff to determine the eigenneurons with larger 
% relative eigenexpression than the cutoff

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Both row-wise and column-wise permutation of D to generate permutated Drc
[m,n]=size(D);
%% First,generate row-wise permutated Dr
for i=1:m
    tmp=randperm(n);
    Dr(i,1:n)=D(i,tmp);
end
%% Second, perform column-wise permutation of Dr to finally generate Drc
for j=1:n
    tmp=randperm(m);
    Drc(1:m,j)=Dr(tmp,j);
end

% SVD for D
[U,S,V]=svd(D,0);
% Relative eigenexpression of S
RV_S=(diag(S).*diag(S))/sum((diag(S).*diag(S)));

% SVD for Drc
[u,s,v]=svd(Drc,0);
% Relative eigenexpression of S
RV_s=(diag(s).*diag(s))/sum((diag(s).*diag(s)));

% Axes for barchart
scrsz = get(0,'ScreenSize');
figure('Position',[scrsz(3)*1/20 scrsz(3)*1/20 scrsz(3)*7/10*(0.815/0.775) scrsz(3)*7/10])
set(gcf,'paperpositionmode','auto','color','w')
axes('position',[0.25 0.2 0.38 0.5])
h=barh([RV_S RV_s],0.8);
set(gca,'xaxislocation','top')
set(gca,'ylim',[0.5 n+0.5],'ydir','reverse','fontsize',8,'ycolor','k')
set(gca,'tickdir','out','ticklength',[0.005,0.025],'xcolor','k','box','off')
set(h(1),'facecolor','k','edgecolor','k')
set(h(2),'facecolor',[0.8 0.8 0.8],'edgecolor',[0.8 0.8 0.8])
ylabel('Eigenvector')
xlabel('Relative eigenexpression')
[legend_h,object_h,plot_h,text_strings]=legend('Observed','Random');
legend('boxoff')
set(legend_h,'fontsize',6)
hold on
plot([RV_s(1) RV_s(1)],[0 n],'-.','color','k','linewidth',1) % cutoff marked with dash-dot line style

return





